/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.memory.SparseMemory;
import emulator.hardware.nmos6502.Cpu6502;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;

public class Cpu6502PrintOpcodeTest {
    @Test
    public void testLDX_Immediate() {
        this.checkPrintOpcode(new int[]{162, 255}, "LDX #$FF");
    }

    @Test
    public void testSEI() {
        this.checkPrintOpcode(new int[]{120}, "SEI ");
    }

    @Test
    public void testTXS() {
        this.checkPrintOpcode(new int[]{154}, "TXS ");
    }

    @Test
    public void testCLD() {
        this.checkPrintOpcode(new int[]{216}, "CLD ");
    }

    @Test
    public void testJSR() {
        this.checkPrintOpcode(new int[]{32, 63, 253}, "JSR $FD3F");
    }

    @Test
    public void testLDA_AbsoluteX() {
        this.checkPrintOpcode(new int[]{189, 254, 175}, "LDA $AFFE,X");
    }

    @Test
    public void testSTA_ZeroPageX() {
        this.checkPrintOpcode(new int[]{149, 254}, "STA $FE,X");
        int[] nArray = new int[2];
        nArray[0] = 149;
        this.checkPrintOpcode(nArray, "STA $00,X");
    }

    @Test
    public void testBNE() {
        this.checkPrintOpcode(new int[]{208, 245}, "BNE $0FF7");
    }

    @Test
    public void testSTA_ZeroPage() {
        this.checkPrintOpcode(new int[]{133, 254}, "STA $FE");
    }

    @Test
    public void testSTA_IndirectX() {
        this.checkPrintOpcode(new int[]{129, 193}, "STA ($C1,X)");
    }

    @Test
    public void testSTA_IndirectY() {
        this.checkPrintOpcode(new int[]{145, 193}, "STA ($C1),Y");
    }

    private void checkPrintOpcode(int[] sequence, String expected_result) {
        SparseMemory memory = new SparseMemory();
        int i = 0;
        while (i < sequence.length) {
            memory.write(4096 + i, sequence[i]);
            ++i;
        }
        Cpu6502 cpu = new Cpu6502();
        cpu.attach(memory, null);
        cpu.setPC(4096);
        cpu.setAccu(new HwByte(18L));
        cpu.setX(new HwByte(63L));
        cpu.setY(new HwByte(154L));
        ByteArrayOutputStream out_buf = new ByteArrayOutputStream();
        cpu.printNextOpcode(new PrintStream(out_buf));
        String prefix = "";
        int i2 = 0;
        while (i2 < 3) {
            prefix = i2 < sequence.length ? String.valueOf(prefix) + new HwByte((long)sequence[i2]) + " " : String.valueOf(prefix) + "   ";
            ++i2;
        }
        Assert.assertEquals((Object)new HwWord(4096L), (Object)cpu.getPC());
        Assert.assertEquals((Object)(String.valueOf(prefix) + " " + expected_result + "\r\n"), (Object)out_buf.toString());
    }
}

